 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ;                                                                         
 ;   Completely rewritten 11.19.2000.                                      
 ; 
 (DEFUN SPLAT (sepchr linn / pos len name1 strlst)
  (while (/= (strlen linn) 0)
 ; Ŀ
 ;   Find the first separator character, save everything before it into    
 ;   the Name1 variable, remove it from the start of the string Linn.      
 ; 
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
 ; Ŀ
 ;   Remove spaces from the front and back of Name1.                       
 ; 
         (while (and (> (strlen name1) 0)
                     (= (substr name1 (setq len (strlen name1))) " "))
                (setq name1 (substr name1 1 (1- len))))
         (while (and (> (strlen name1) 0)
                     (= (substr name1 1 1) " "))
                (setq name1 (substr name1 2)))
 ; Ŀ
 ;   Add Name1 to the substring list Strlst.                               
 ; 
         (setq strlst (append strlst (list name1))))
 ; Ŀ
 ;   If the string contained no separator characters then Strlst will be   
 ;   nil, so return a list containing the original string.                 
 ; 
  (if (null strlst) (setq strlst (list linn)))
 strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 
